/*
 * GeneratorNode.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

import java.awt.*;

/**
 * GeneratorNodes create packets and put them into availble channels.  It graphically
 * displays how many packets it has created.  It overrides the stardard Node 
 * paint(Graphics) method.  It uses the class GeneratorNodeBehavior.
 */
public class GeneratorNode extends Node {

    public GeneratorNode(SimulationPanel sp, ThreadGroup tg) {
	super(sp, tg, Color.black);
	my_behavior = new GeneratorNodeBehavior();
	setName("**UNNAMED Generator**");
    }

    public void paint(Graphics g) {
	String num_created = Integer.toString(((GeneratorNodeBehavior)my_behavior).numCreated());
	g.setColor(my_color);
	if (!this.isEnabled() && !this.forDisplayOnly) g.setColor(Color.gray);
	g.fillOval(this.pos.x - 10, this.pos.y - 10, 20, 20);
	g.setColor(Color.white);
	g.fillOval(this.pos.x - 5, this.pos.y - 5, 10, 10);
	if (this.isSelected()) {
	    g.setColor(Color.red);
	    g.drawRect(this.pos.x - 10, this.pos.y - 10, 20, 20);
	}
	g.setColor(Color.black);
	g.drawString(num_created, this.pos.x - 35, this.pos.y + 5);
    }
}
