/*
 * ControlPanel.java
 * Part of the BinSort problem set.
 *
 * Developed for "Rethinking CS101", a project of Lynn Andrea Stein's AP Group.
 * For more information, see http://www.ai.mit.edu/projects/cs101, the
 * CS101 homepage or email las@ai.mit.edu.
 *
 * Copyright (C) 1997 Massachusetts Institute of Technology.
 * Please do not redistribute without obtaining permission.
 */

package BinSort;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.util.Enumeration;
import java.util.StringTokenizer;

class ControlPanel extends Panel {

    public static final int GENERATOR = -1;
    public static final int TERMINATOR = -2;
    public static final int CHANNEL = -3;
    public static final int MAX_NODES = 3;
     
    /*private*/ boolean channelSelected;
    /*private*/ int selected;
    private Node myNodes[];
    private GeneratorNode generatorNode;
    private TerminatorNode terminatorNode;
    private Channel myChannels[];
    private boolean isRunning = false;
    private Class nodeClasses[];
    String nodeNames[]; // used by sp to parse
    Main myMain;
    
    public ControlPanel(String[] nodeTypes, Main my_Main) {
	super();
	
	myMain = my_Main;
	nodeNames = nodeTypes;
	nodeClasses = new Class[nodeTypes.length];
	nodeClasses = getClasses(nodeTypes);
	
	// dummy variables
	SimulationPanel sp = new SimulationPanel(this);
	ThreadGroup tg = new ThreadGroup("dummy threadgroup");

	// the generator and terminator nodes
  	generatorNode = new GeneratorNode(sp, tg);
	generatorNode.setDisplayOnly();
    	terminatorNode = new TerminatorNode(sp, tg);
	terminatorNode.setDisplayOnly();
	
	selected = GENERATOR;
	
	// the routing nodes and channels
	myNodes = new Node[nodeClasses.length];
	myChannels = new Channel[nodeClasses.length + 1];
	Node lastNode = generatorNode;
	try {
	    for (int i = 0; i < nodeClasses.length; i++) {
		NodeBehavior nb = (NodeBehavior) nodeClasses[i].newInstance();
		myNodes[i] = new Node(nb, sp, tg, SimulationPanel.COLOR[i]);
		myNodes[i].setDisplayOnly();
		myChannels[i] = new Channel(lastNode, myNodes[i], sp, tg);
		lastNode = myNodes[i];
	    }
	}
	catch(InstantiationException e) {
//	    throw(new BadNodeBehaviorException("The class loaded gave an error at instantiation"));
	}
	catch(IllegalAccessException e) {
//	    throw(new BadNodeBehaviorException("The class loaded gave an error concerning illegal access"));
	}
	catch(ClassCastException e) {
//	    throw(new BadNodeBehaviorException("The class loaded doesn't implement NodeBehavior"));
	}
	catch(SameNodesException e) {}
	
	try {
	    myChannels[nodeClasses.length] = new Channel(lastNode, terminatorNode, sp, tg);
	}
	catch(SameNodesException e) {}
	
	setPositions();
	
	// 1.1 Event Handler
	this.addMouseListener(new MouseAdapter() {
	    public void mouseReleased(MouseEvent e) {
		int sel = (e.getX() - 20) / 40 + 1;
		if (sel <= 1) {
		    sel = GENERATOR;
		    ControlPanel.this.selected = sel;
		    channelSelected = false;
		    repaint();
		    return;
		}
		else if (sel == (6)) {
		    sel = CHANNEL;
		    ControlPanel.this.selected = sel;
		    channelSelected = true;
		    repaint();
		    return;
		}
		else if (sel == (myNodes.length + 2)) {
		    sel = TERMINATOR;
		    ControlPanel.this.selected = sel;
		    channelSelected = false;
		    repaint();
		    return;
		}
		else if ((sel > 1) && (sel < myNodes.length + 2)) {
		    ControlPanel.this.selected = sel;
		    channelSelected = false;
		    repaint();
		    return;
		}
	    }
	});
    }

    private void setPositions() {
	Dimension d = this.getSize();
	generatorNode.setPos(40, d.height / 2);
	for (int i = 0; i < myNodes.length; i++) {
	    myNodes[i].setPos(80 + (40 * i), d.height / 2);
	}
	terminatorNode.setPos(80 + 40 * myNodes.length, d.height / 2);
    }
    
    public Dimension getPreferredSize() { return(new Dimension(250, 50)); }
    
    public Dimension getMinimumSize() { return(getPreferredSize()); }

    void setRunning(boolean b) { 
	isRunning = b; 
	repaint();
    }
    
    public boolean channelSelected() { return channelSelected; }

    public Node getNewNode(SimulationPanel sp, ThreadGroup tg) throws NoNodeSelectedException {
	switch(this.selected) {
	    
	    case GENERATOR:
		return(new GeneratorNode(sp, tg));
	    case TERMINATOR:
		return(new TerminatorNode(sp, tg));
	    default:
		try {
		return(new Node((NodeBehavior)(this.nodeClasses[selected-2].newInstance()),sp,tg,SimulationPanel.COLOR[selected-2]));
		}
		catch(Exception e) {
		    //SHOULD NEVER HAPPEN
		    throw(new NoNodeSelectedException());
		}
		catch(NoSuchMethodError e) {
		    System.out.println("Error : " + e);
		    throw(new NoNodeSelectedException());
	    }
	}
    }
    
    //this should be replaced by a generic converter...
    /*private*/ Class[] getClasses(String[] node_types_string) {
	
	// Load up the classes for Nodes
	if (node_types_string.length > MAX_NODES) {
	    System.out.println("Maximum of " + MAX_NODES + " node behaviors");
	    System.exit(0);
	}
	Class node_classes[] = new Class[node_types_string.length];
	try {
	    for (int i = 0; i < node_types_string.length; i++) {
		node_classes[i] = Class.forName(node_types_string[i]);
	    }
	}
	catch(ClassNotFoundException e) {
	    System.out.println("The Node Behavior you indicated cannot be found.");
	    System.out.println("Exiting");
	    System.exit(0);
	}
	return(node_classes);
    }

    public void paint(Graphics g) {
	setPositions();
	g.setColor(Color.white);
	g.drawRect(0, 0, this.getSize().width, this.getSize().height);
	for (int i = 0; i < myChannels.length ; i++) myChannels[i].paint(g);
	generatorNode.paint(g);
	for (int i = 0; i < myNodes.length; i++) myNodes[i].paint(g);	
	terminatorNode.paint(g);
	
	g.setColor(Color.black);
	g.fillRect(220, this.getSize().height / 2 - 3, 40, 6);
	g.setColor(Color.red);
	
	int rectPos;
	String st = "Not Running";
	if (isRunning) st = "Running";
	String st2;

	switch(this.selected) {
	    case GENERATOR:  
		st2 = "Generator"; 
		rectPos = 1;
		break;
	    case TERMINATOR: 
		st2 = "Terminator"; 
		rectPos = myNodes.length + 2;
		break;
	    case CHANNEL:    
		st2 = "Channel"; 
		rectPos = 6;
		break;
	    default:
		String temp = this.nodeClasses[this.selected - 2].toString();
		st2 = temp.substring(14);
		rectPos = selected;
	}
	    
	g.drawRect(40 * rectPos - 15, this.getSize().height / 2 - 15, 30, 30);
	g.setColor(Color.black);
	g.drawString(st2, 500, this.getSize().height - 15);
	g.drawString(st, 400, this.getSize().height - 15);
    }
}
