/*
 * CalculatorGUI.java
 *
 * Created on September 29, 2005, 1:13 AM
 *
 * (C) 2005 Olin College
 */

package calculator;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

/**
 * The calculator user interface.  Uses several Java Swing components,
 * layout managers, and concepts.
 */
public class CalculatorGUI extends JFrame
        implements Calculator, ActionListener
{
    /** the display */
    private JTextField display;
    
    /** queue of pending button-presses */
    private IntPipe queue;

    /** the button layout.  5 rows of 4 */
    private int[] buttonLayout =  new int[] {
        CLEAR, MEMORY, RECALL, BACKSPACE,
        7, 8, 9, OP_DIV,
        4, 5, 6, OP_MUL,
        1, 2, 3, OP_SUB,
        0, DOT, EQUALS, OP_ADD
    };
    
    /** Creates a new instance of CalculatorGUI */
    public CalculatorGUI() {
        super("Calculator");
        this.queue = new IntPipe();
        createGUI();
        setDisplay("Ready");
    }

    /**
     * Builds the user interface for the calculator.
     */
    private void createGUI() {
        // display area
        this.display = new JTextField("-0.1234567890123456789+");
        this.display.setHorizontalAlignment(JTextField.RIGHT);
        this.display.setEditable(false);
        this.display.setFont(new Font("Monospaced", Font.BOLD, 24));
        this.getContentPane().add(display, BorderLayout.NORTH);

        // the buttons
        JPanel buttonPanel = new JPanel(new GridLayout(0,4));
        for (int i=0; i<buttonLayout.length; i++) {
            int buttonid = buttonLayout[i];
            if (buttonid == NO_OP) {
                // add a blank space
                buttonPanel.add(new JPanel());
            } else {
                // add the button
                JButton jb = new JButton(buttonLabels[buttonid]);
                jb.setActionCommand(String.valueOf(buttonid));
                jb.addActionListener(this);
                buttonPanel.add(jb);
            }
        }
        this.getContentPane().add(buttonPanel, BorderLayout.CENTER);
        
        // set up the window and show it
        this.setDefaultCloseOperation(this.EXIT_ON_CLOSE);
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    // javadoc from Calculator
    public void setDisplay(String text) {
        this.display.setText(text);
    }
    
    // javadoc from Calculator
    public String getDisplay() {
        return display.getText();
    }
    
    // javadoc from Calculator
    public int getNextButton() {
        // get the button from the event queue
        return queue.remove();
    }

    // javadoc from ActionListener
    public void actionPerformed(ActionEvent evt) {
        // get the button id from the event
        int buttonPressed = Integer.parseInt(evt.getActionCommand());
        // add the button to the event queue
        queue.add(buttonPressed);
    }
    
}
