/*
 * Calculator.java
 *
 * Created on September 28, 2005, 11:59 PM
 *
 * (C) 2005 Olin College
 */

package calculator;

/**
 * Inputs and outputs to the calculator gui.
 */
public interface Calculator {
    /** the decimal button */
    public static final int DOT = 10;
    
    /** the first operator */
    public static final int FIRST_OP = 11;
    
    /** the addition button */
    public static final int OP_ADD = 11;
    
    /** the subtraction button */
    public static final int OP_SUB = 12;
    
    /** the multiplication button */
    public static final int OP_MUL = 13;
    
    /** the divisiion button */
    public static final int OP_DIV = 14;

    /** the last operator */
    public static final int LAST_OP = 14;
    
    /** the equals button */
    public static final int EQUALS = 15;
    
    /** the clear button */
    public static final int CLEAR = 16;
    
    /** the backspace button */
    public static final int BACKSPACE = 17;
    
    /** the memory button */
    public static final int MEMORY = 18;
    
    /** the recall button */
    public static final int RECALL = 19;
    
    /** one greater than the value of the last button */
    public static final int LAST = 20;
    
    /** not a button.  use this or not as you wish */
    public static final int NO_OP = -1;
    
    /**
     * An array of button labels.  For button Ids of 0 through LAST-1,
     * the value of this array represents the text of the corresponding
     * button.
     */
    public static final String[] buttonLabels = {
        "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
        ".", "+", "-", "*", "/", "=", "C", "<", "M", "R"
    };
    
    /**
     * Gets the next button press by the user.  This method will block
     * until the user pushes a button, if necessary.
     * @return an int reperesenting the next button that was pressed.
     */
    public int getNextButton();
    
    /**
     * Gets the text currently displayed on the calculator.
     * <p><b>Note:</b>
     * It is often better for the model to have its own record
     * of what the display should be rather than relying on the display
     * itself for storage.
     * @return the current contents of the display, as a String.
     */
    public String getDisplay();
    
    /**
     * Sets the current display on the calculator.
     * @param text the String to show on the display.
     */
    public void setDisplay(String text);
}
