/*
 * Decompiled with CFR 0.152.
 */
package calculator;

import calculator.Calculator;
import calculator.IntPipe;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CalculatorGUI
extends JFrame
implements Calculator,
ActionListener {
    private JTextField display;
    private IntPipe queue;
    private int[] buttonLayout = new int[]{16, 18, 19, 17, 7, 8, 9, 14, 4, 5, 6, 13, 1, 2, 3, 12, 0, 10, 15, 11};

    public CalculatorGUI() {
        super("Calculator");
        this.queue = new IntPipe();
        this.createGUI();
        this.setDisplay("Ready");
    }

    private void createGUI() {
        this.display = new JTextField("-0.1234567890123456789+");
        this.display.setHorizontalAlignment(4);
        this.display.setEditable(false);
        this.display.setFont(new Font("Monospaced", 1, 24));
        this.getContentPane().add((Component)this.display, "North");
        JPanel buttonPanel = new JPanel(new GridLayout(0, 4));
        for (int i = 0; i < this.buttonLayout.length; ++i) {
            int buttonid = this.buttonLayout[i];
            if (buttonid == -1) {
                buttonPanel.add(new JPanel());
                continue;
            }
            JButton jb = new JButton(buttonLabels[buttonid]);
            jb.setActionCommand(String.valueOf(buttonid));
            jb.addActionListener(this);
            buttonPanel.add(jb);
        }
        this.getContentPane().add((Component)buttonPanel, "Center");
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.pack();
        this.setVisible(true);
    }

    public void setDisplay(String text) {
        this.display.setText(text);
    }

    public String getDisplay() {
        return this.display.getText();
    }

    public int getNextButton() {
        return this.queue.remove();
    }

    public void actionPerformed(ActionEvent evt) {
        int buttonPressed = Integer.parseInt(evt.getActionCommand());
        this.queue.add(buttonPressed);
    }
}

